(function( $ ) {
	'use strict';
	
	var that;
	
	var fgm2wcp = {
	    
	    plugin_id: 'fgm2wcp',
	    fatal_error: '',
	    is_logging: false,
	    
	    /**
	     * Manage the behaviour of the Skip Media checkbox
	     */
	    hide_unhide_media: function()  {
		$("#media_import_box").toggle(!$("#skip_media").is(':checked'));
	    },

	    /**
	     * Security question before deleting WordPress content
	     */
	    check_empty_content_option: function () {
		var confirm_message;
		var action = $('input:radio[name=empty_action]:checked').val();
		switch ( action ) {
		    case 'imported':
			confirm_message = objectL10n.delete_imported_data_confirmation_message;
			break;
		    case 'all':
			confirm_message = objectL10n.delete_all_confirmation_message;
			break;
		    default:
			alert(objectL10n.delete_no_answer_message);
			return false;
			break;
		}
		return confirm(confirm_message);
	    },
	    
	    /**
	     * Start the logger
	     */
	    start_logger: function() {
		that.is_logging = true;
		clearTimeout(that.display_logs_timeout);
		clearTimeout(that.update_progressbar_timeout);
		clearTimeout(that.update_wordpress_info_timeout);
		that.update_display();
	    },
	    
	    /**
	     * Stop the logger
	     */
	    stop_logger: function() {
		that.is_logging = false;
	    },
	    
	    
	    /**
	     * Update the display
	     */
	    update_display: function() {
		that.display_logs();
		that.update_progressbar();
		that.update_wordpress_info();
	    },
	    
	    /**
	     * Display the logs
	     */
	    display_logs: function() {
		if ( $("#logger_autorefresh").is(":checked") ) {
		    $.ajax({
			url: objectPlugin.log_file_url,
			cache: false
		    }).done(function(result) {
			$('#action_message').html(''); // Clear the action message
			$("#logger").html('');
			result.split("\n").forEach(function(row) {
			    if ( row.substr(0, 7) === '[ERROR]' || row.substr(0, 9) === '[WARNING]' || row === 'IMPORT STOPPED BY USER') {
				row = '<span class="error_msg">' + row + '</span>'; // Mark the errors in red
			    }
			    // Test if the import is completed
			    else if ( row === 'IMPORT COMPLETED' ) {
				row = '<span class="completed_msg">' + row + '</span>'; // Mark the completed message in green
				$('#action_message').html(objectL10n.import_completed)
				.removeClass('failure').addClass('success');
			    }
			    $("#logger").append(row + "<br />\n");

			});
			$("#logger").append('<span class="error_msg">' + that.fatal_error + '</span>' + "<br />\n");
		    }).always(function() {
			if ( that.is_logging ) {
			    that.display_logs_timeout = setTimeout(that.display_logs, 1000);
			}
		    });
		} else {
		    if ( that.is_logging ) {
			that.display_logs_timeout = setTimeout(that.display_logs, 1000);
		    }
		}
	    },

	    /**
	     * Update the progressbar
	     */
	    update_progressbar: function() {
		$.ajax({
		    url: objectPlugin.progress_url,
		    cache: false,
		    dataType: 'json'
		}).always(function(result) {
		    // Move the progress bar
		    var progress = 0;
		    if((result.total !== undefined) && (Number(result.total) !== 0)) {
		      progress = Math.round(Number(result.current) / Number(result.total) * 100);
		    }
		    jQuery('#progressbar').progressbar('option', 'value', progress);
		    jQuery('#progresslabel').html(progress + '%');
		    if ( that.is_logging ) {
			that.update_progressbar_timeout = setTimeout(that.update_progressbar, 1000);
		    }
		});
	    },

	    /**
	     * Update WordPress database info
	     */
	    update_wordpress_info: function() {
		var data = 'action=' + that.plugin_id + '_import&plugin_action=update_wordpress_info';
		$.ajax({
		    method: "POST",
		    url: ajaxurl,
		    data: data
		}).done(function(result) {
		    $('#fgm2wc_database_info_content').html(result);
		    if ( that.is_logging ) {
			that.update_wordpress_info_timeout = setTimeout(that.update_wordpress_info, 1000);
		    }
		});
	    },
	    
	    /**
	     * Empty WordPress content
	     * 
	     * @returns {Boolean}
	     */
	    empty_wp_content: function() {
		if (that.check_empty_content_option()) {
		    // Start displaying the logs
		    that.start_logger();
		    $('#empty').attr('disabled', 'disabled'); // Disable the button
		    
		    var data = $('#form_empty_wordpress_content').serialize() + '&action=' + that.plugin_id + '_import&plugin_action=empty';
		    $.ajax({
			method: "POST",
			url: ajaxurl,
			data: data
		    }).done(function(result) {
			if (result) {
			    that.fatal_error = result;
			}
			alert(objectL10n.content_removed_from_wordpress);
		    }).fail(function(result) {
			that.fatal_error = result.responseText;
		    }).always(function() {
			that.stop_logger();
			$('#empty').removeAttr('disabled'); // Enable the button
		    });
		}
		return false;
	    },
	    
	    /**
	     * Test the database connection
	     * 
	     * @returns {Boolean}
	     */
	    test_database: function() {
		// Start displaying the logs
		that.start_logger();
		$('#test_database').attr('disabled', 'disabled'); // Disable the button
		$('#database_test_message').html('');
		
		var data = $('#form_import').serialize() + '&action=' + that.plugin_id + '_import&plugin_action=test_database';
		$.ajax({
		    method: 'POST',
		    url: ajaxurl,
		    data: data,
		    dataType: 'json'
		}).done(function(result) {
		    if ( typeof result.message !== 'undefined' ) {
			$('#database_test_message').toggleClass('success', result.status === 'OK')
			.toggleClass('failure', result.status !== 'OK')
			.html(result.message);
		    }
		    if ( typeof result.websites !== 'undefined' ) {
			$('#website').html(result.websites);
		    }
		    if ( typeof result.stores !== 'undefined' ) {
			$('#store').html(result.stores);
		    }
		}).fail(function(result) {
		    that.fatal_error = result.responseText;
		}).always(function() {
		    that.stop_logger();
		    $('#test_database').removeAttr('disabled'); // Enable the button
		});
		return false;
	    },
	    
	    /**
	     * Save the settings
	     * 
	     * @returns {Boolean}
	     */
	    save: function() {
		// Start displaying the logs
		that.start_logger();
		$('#save').attr('disabled', 'disabled'); // Disable the button
		
		var data = $('#form_import').serialize() + '&action=' + that.plugin_id + '_import&plugin_action=save';
		$.ajax({
		    method: "POST",
		    url: ajaxurl,
		    data: data
		}).done(function() {
		    alert(objectL10n.settings_saved);
		}).fail(function(result) {
		    that.fatal_error = result.responseText;
		}).always(function() {
		    that.stop_logger();
		    $('#save').removeAttr('disabled'); // Enable the button
		});
		return false;
	    },
	    
	    /**
	     * Start the import
	     * 
	     * @returns {Boolean}
	     */
	    start_import: function() {
		that.fatal_error = '';
		// Start displaying the logs
		that.start_logger();
		
		// Disable the import button
		that.import_button_label = $('#import').val();
		$('#import').val(objectL10n.importing).attr('disabled', 'disabled');
		// Show the stop button
		$('#stop-import').show();
		// Clear the action message
		$('#action_message').html('');
		
		// Run the import
		var data = $('#form_import').serialize() + '&action=' + that.plugin_id + '_import&plugin_action=import';
		$.ajax({
		    method: "POST",
		    url: ajaxurl,
		    data: data
		}).done(function(result) {
		    if (result) {
			that.fatal_error = result;
		    }
		}).fail(function(result) {
		    that.fatal_error = result.responseText;
		}).always(function() {
		    that.stop_logger();
		    that.update_display(); // Get the latest information after the import was stopped
		    that.reactivate_import_button();
		});
		return false;
	    },
	    
	    /**
	     * Reactivate the import button
	     * 
	     */
	    reactivate_import_button: function() {
		$('#import').val(that.import_button_label).removeAttr('disabled');
		$('#stop-import').hide();
	    },
	    
	    /**
	     * Stop import
	     * 
	     * @returns {Boolean}
	     */
	    stop_import: function() {
		$('#stop-import').attr('disabled', 'disabled');
		$('#action_message').html(objectL10n.import_stopped_by_user)
		.removeClass('success').addClass('failure');
		// Stop the import
		var data = $('#form_import').serialize() + '&action=' + that.plugin_id + '_import&plugin_action=stop_import';
		$.ajax({
		    method: "POST",
		    url: ajaxurl,
		    data: data
		}).fail(function(result) {
		    that.fatal_error = result.responseText;
		}).always(function() {
		    that.stop_logger();
		    $('#stop-import').removeAttr('disabled'); // Enable the button
		    that.reactivate_import_button();
		});
		return false;
	    },
	    
	    /**
	     * Update the products
	     * 
	     * @returns {Boolean}
	     */
	    update: function() {
		that.fatal_error = '';
		// Start displaying the logs
		that.start_logger();
		
		// Disable the import button
		$('#update').attr('disabled', 'disabled');
		// Show the stop button
		$('#stop-import').show();
		// Clear the action message
		$('#action_message').html('');
		
		// Run the import
		var data = $('#form_import').serialize() + '&action=' + that.plugin_id + '_import&plugin_action=update';
		$.ajax({
		    method: "POST",
		    url: ajaxurl,
		    data: data
		}).done(function(result) {
		    if (result) {
			that.fatal_error = result;
		    }
		}).fail(function(result) {
		    that.fatal_error = result.responseText;
		}).always(function() {
		    that.stop_logger();
		    that.update_display(); // Get the latest information after the import was stopped
		    that.reactivate_update_button();
		});
		return false;
	    },
	    
	    /**
	     * Reactivate the update button
	     * 
	     */
	    reactivate_update_button: function() {
		$('#update').removeAttr('disabled');
		$('#stop-import').hide();
	    },
	    
	    /**
	     * Copy a field value to the clipboard
	     * 
	     */
	    copy_to_clipboard: function() {
		var containerid = $(this).data("field");
		if (document.selection) {
		    var range = document.body.createTextRange();
		    range.moveToElementText(document.getElementById(containerid));
		    range.select().createTextRange();

		} else if (window.getSelection) {
		    window.getSelection().removeAllRanges();
		    var range = document.createRange();
		    range.selectNode(document.getElementById(containerid));
		    window.getSelection().addRange(range);
		}
		document.execCommand("copy");
		return false;
	    }
	    
	};
	
	/**
	 * Actions to run when the DOM is ready
	 */
	$(function() {
	    that = fgm2wcp;
	    
	    $('#progressbar').progressbar({value : 0});

	    // Skip media checkbox
	    $("#skip_media").bind('click', that.hide_unhide_media);
	    that.hide_unhide_media();

	    // Empty WordPress content confirmation
	    $("#form_empty_wordpress_content").bind('submit', that.check_empty_content_option);

	    // Partial import checkbox
	    $("#partial_import").hide();
	    $("#partial_import_toggle").click(function() {
		$("#partial_import").slideToggle("slow");
	    });
	    
	    // Empty button
	    $('#empty').click(that.empty_wp_content);
	    
	    // Test database button
	    $('#test_database').click(that.test_database);
	    
	    // Save settings button
	    $('#save').click(that.save);
	    
	    // Import button
	    $('#import').click(that.start_import);
	    
	    // Stop import button
	    $('#stop-import').click(that.stop_import);
	    
	    // Update button
	    $('#update').click(that.update);
	    
	    // Display the logs
	    $('#logger_autorefresh').click(that.display_logs);
	    
	    $('.copy_to_clipboard').click(that.copy_to_clipboard);
	    
	    that.update_display();
	});

	/**
	 * Actions to run when the window is loaded
	 */
	$( window ).load(function() {
	    
	});

})( jQuery );
